/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <Operation.h>
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

//select part of curve and do linear fit
void SelPartCurveAndDoLinearFit()
{
    Worksheet    wks;
    GraphPage    gp;
    
    gp.Create("line.otp", CREATE_VISIBLE);
    wks.Create("origin.otw",CREATE_VISIBLE); // Newly created worksheet is active
    LT_execute("col(1)=data(1,30);col(2)=0.05 * col(1)*col(1)+3;");	//create the data
    
    wks.AddCol();
    wks.AddCol(); //add new cols
    
    Curve   crv(wks, 1);	//get curve for plot
    
    //plot the original curve
    GraphLayer    gl; 
    gl = gp.Layers(0);
    
    int nPlot = gl.AddPlot(crv);
    DataPlot dp = gl.DataPlots(nPlot);
    
    //get the curve datarange from the dataplot
    XYRange dr;
    dp.GetDataRange(dr);
    
    //get the data
    vector vX, vY;
    dr.GetData(vY, vX);
    
    //select part of curve data
    int nCount = vX.GetSize();
    vY.GetSubVector(vY, nCount/4, nCount * 3 / 4 );
    vX.GetSubVector(vX, nCount/4, nCount * 3 / 4 );
    
    //set the datarange
    dr.SetData(&vY, &vX);
    
    //get the datarange tree
    Tree trInput;
    string strTagName = _L("InputData");
    trInput.AddNode(strTagName);
	TreeNode trTemp = trInput.GetNode(strTagName);
    dr.GetTree(trInput, FALSE);
	//do linear fit
	
	//create "FitLinear" Operation object
	bool bOK;
	int nOption = 0;
	Operation& op = (Operation &)op_create("FitLinear", bOK, nOption);
	if(op == NULL)
		return;
   
	//get the inputdata tree
	TreeNode trOp;
	op.GetTree(trOp);
	TreeNode trCalInput = trOp.GUI.InputData;
	
	//set the input data
	trCalInput.Replace(trInput, true, true);
	
	//set the operation tree
	op.SetTree(trOp);
   	
	//calculate
   	int nAutoUpdate = 0;
   	op.OnNoEdit(nOption, nAutoUpdate, NULL);
    op.GetTree(trOp);
   	op.Calculate();
	
   	//the the operation tree after calculate
    op.GetTree(trOp);
   
    //the the fit curve tree
    TreeNode trResultCurves = trOp.ResultCurves;
    TreeNode trCurve = trResultCurves.FirstNode.FitCurves;
    
    //get the result curve data
    vector vFitX, vFitY;
    vFitX = trCurve.FitX.dVals;
    vFitY = trCurve.FitY.dVals;
    
    //set the datarange with the result curve data
    XYRange xy;
    xy.Add(wks, 2, "X");
    xy.Add(wks, 3, "Y");
    xy.SetData(&vFitY, &vFitX);
    
    //create new graph page
    GraphPage gpFit;
    gpFit.Create();
    GraphLayer glFit = gpFit.Layers(0);
    
    //make plot
    xy.MakePlot(glFit);
    
    //destroy the operation object on the end
    op_destroy_on_cancel(op);
}


